RequireScript("TimeMonitor.js");

function MusicManager(){
	
	this.act_path = "";
	this.file = undefined;
	this.volume = 0;
	this.valid = false;
	this.loop = false;
	
	//crossfading
	this.new_path = "";
	this.new_file = undefined;
	this.new_volume = 0;
	this.new_volume_aim = 0;
	
	this.old_volume = 0;
	this.new_loop = false;
	this.lockCrossfade = false;
	this.new_tm = undefined;
}

MusicManager.prototype.setVolume = function(v){

	this.volume = Math.max(Math.min(v,255),0);
	if(this.file!=undefined)
			this.file.setVolume(this.volume);

}

MusicManager.prototype.fadeToVolume = function(v,rs,rs_name,vol_per_frame,mm_name){
	
	var sign = ">";
	if(v<this.getVolume())sign = "<";
	rs.add("MUSICMANAGER_fadeToVolume","if("+mm_name+".getVolume()"+sign+" "+v+"){"+mm_name+".setVolume("+mm_name+".getVolume()-"+vol_per_frame+")}else{"+rs_name+".del(\"MUSICMANAGER_fadeToVolume\");};");

}

MusicManager.prototype.getVolume = function(){

	return this.volume;
}

MusicManager.prototype.changeAndPlay = function(path,loop){
	
	if(path!=this.act_path){
		if(this.file!=undefined)
			this.file.stop();
		this.act_path	= path;
		this.file = objectsystem.sound.get(path);
		this.file.setVolume(this.volume);
		this.valid = true;
	}
	this.file.play(loop);
	this.loop = loop;

}

MusicManager.prototype.change = function(path){
	
	if(path!=this.act_path){
		if(this.file!=undefined)
			this.file.stop();
		this.act_path	= path;
		this.file = objectsystem.sound.get(path);
		this.file.setVolume(this.volume);
		this.valid = true;
	}
	

}

MusicManager.prototype.crossfadeTo = function(path,loop,ms,vol){

	this.new_path = path;
	this.new_file = objectsystem.sound.get(path);
	this.new_volume = 0;
	
	this.new_volume_aim = vol;
	this.new_tm = new TimeMonitor(ms);
	this.old_volume = this.volume;
	this.new_file.setVolume(this.new_volume);
	this.new_file.play(loop);
	this.new_loop = loop;
	this.lockCrossfade = true;
	
	this.new_tm.start();
	
}

MusicManager.prototype.computeCrossfade = function(){

	if(!this.lockCrossfade)return;
	var finished = false;
	var tmpp = this.new_tm.getPercent();
	
	this.new_volume = tmpp/100*this.new_volume_aim;
	this.new_file.setVolume(this.new_volume);
	this.volume = this.old_volume- tmpp/100*this.old_volume;
	this.file.setVolume(this.volume);
	
	if(this.new_volume == this.new_volume_aim){
		this.file.stop();
		this.path = this.new_path;
		this.volume = this.new_volume;
		this.file = this.new_file;
		this.loop = this.new_loop;
		this.lockCrossfade = false;
		finished = true;
		}
	
	
	return finished;

}

MusicManager.prototype.getFile = function(){

	return this.file;

}

MusicManager.prototype.play = function(loop){
	this.loop = loop;
	if(this.file!=undefined)
			this.file.play(loop);

}

MusicManager.prototype.stop = function(){
	
	if(this.file!=undefined)
			if(this.file.isPlaying())
				this.file.stop();

}

MusicManager.prototype.pause = function(){
	
	if(this.file!=undefined)
			if(this.file.isPlaying())
				this.file.pause();

}

MusicManager.prototype.isPlaying = function(){
	if(this.file!=undefined)
		return this.file.isPlaying();
	else return false;

}

MusicManager.prototype.loaded = function(){
	
	return this.valid;

}

MusicManager.prototype.save = function (file){

	file.write(this.file.isPlaying()?1:0);
	file.write(this.volume);
	file.write(this.act_path);
	file.write(this.loop?0:1);
	

}

MusicManager.prototype.load = function (file){
	
	if(file.readInt()==1){
		this.setVolume(file.readInt());
		this.changeAndPlay(file.readString(),(file.readInt()==0))
		}
	else{
		this.setVolume(file.readInt());
		this.change(file.readString());
		this.loop = (file.readInt()==0);
		
		}


}

musicmanager = new MusicManager();